/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcf;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpMap;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpRule;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpRuleSet;
import oracle.sysman.oix.oixd.OixdDOMReader;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OipcfFixUpMapReader {
    private static final String S_FIXUPMAP = "FIXUPMAP";
    private static final String S_FIXUPRULESET = "FIXUPRULESET";
    private static final String S_FIXUPRULE = "FIXUP";
    private static final String S_FIXUP_RULESET_NAME = "name";
    private static final String S_FIXUP_RULESET_CLASS_NAME = "class";
    private static final String S_FIXUP_RULE_NAME = "name";
    private static final String S_FIXUP_RULE_METHOD_NAME = "method";
    private OipcfFixUpMap m_oFixUpRuleMap = null;
    private Collection m_oFileNames = null;

    protected OipcfFixUpMapReader(Collection oFileNames) {
        this.m_oFileNames = oFileNames;
    }

    static OipcfFixUpMapReader getReader(Collection oFileNames) {
        return new OipcfFixUpMapReader(oFileNames);
    }

    void build() throws IOException, SAXException, ParserConfigurationException, OixdInvalidDocumentException {
        this.m_oFixUpRuleMap = new OipcfFixUpMap();
        Iterator oFileNames = this.m_oFileNames.iterator();
        while (oFileNames.hasNext()) {
            String sFileName = (String)oFileNames.next();
            Document oDoc = OixdDOMReader.getDocument((String)sFileName);
            if (oDoc == null) continue;
            this.build(this.m_oFixUpRuleMap, oDoc, sFileName);
        }
    }

    private void build(OipcfFixUpMap oFixUpRuleMap, Document oDoc, String sFileName) throws OixdInvalidDocumentException {
        Element root = oDoc.getDocumentElement();
        if (!root.getTagName().equalsIgnoreCase(S_FIXUPMAP)) {
            Object[] args = new String[]{sFileName};
            throw new OixdInvalidDocumentException("OUI-65011", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65011", (Object[])args));
        }
        NodeList oFixUpRuleSetNodes = root.getChildNodes();
        if (oFixUpRuleSetNodes != null) {
            int nFixUpRuleSets = oFixUpRuleSetNodes.getLength();
            OipcfFixUpRuleSet oFixUpRuleSet = null;
            OipcfFixUpRule oFixUpRule = null;
            Node oAttrib = null;
            for (int i = 0; i < nFixUpRuleSets; ++i) {
                Object[] args;
                Node oFixUpRuleSetNode = oFixUpRuleSetNodes.item(i);
                if (oFixUpRuleSetNode.getNodeType() != 1 || !oFixUpRuleSetNode.getNodeName().equalsIgnoreCase(S_FIXUPRULESET)) continue;
                NamedNodeMap oFixUpRuleSetAttribs = oFixUpRuleSetNode.getAttributes();
                if (oFixUpRuleSetAttribs == null) {
                    args = new String[]{sFileName};
                    throw new OixdInvalidDocumentException("OUI-65012", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65012", (Object[])args));
                }
                oAttrib = oFixUpRuleSetAttribs.getNamedItem("name");
                if (oAttrib == null) {
                    args = new String[]{sFileName};
                    throw new OixdInvalidDocumentException("OUI-65014", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65014", (Object[])args));
                }
                String sFixUpRuleSetName = oAttrib.getNodeValue();
                oAttrib = oFixUpRuleSetAttribs.getNamedItem(S_FIXUP_RULESET_CLASS_NAME);
                if (oAttrib == null) {
                    args = new String[]{sFileName, sFixUpRuleSetName};
                    throw new OixdInvalidDocumentException("OUI-65015", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65015", (Object[])args));
                }
                String sClass = oAttrib.getNodeValue();
                oFixUpRuleSet = new OipcfFixUpRuleSet(sFixUpRuleSetName, sClass);
                NodeList oFixUpRuleNodes = oFixUpRuleSetNode.getChildNodes();
                if (oFixUpRuleNodes != null) {
                    int nFixUpRules = oFixUpRuleNodes.getLength();
                    for (int j = 0; j < nFixUpRules; ++j) {
                        Node oFixUpRuleNode = oFixUpRuleNodes.item(j);
                        if (oFixUpRuleNode.getNodeType() != 1 || !oFixUpRuleNode.getNodeName().equalsIgnoreCase(S_FIXUPRULE)) continue;
                        NamedNodeMap oFixUpRuleAttribs = oFixUpRuleNode.getAttributes();
                        if (oFixUpRuleAttribs == null) {
                            Object[] args2 = new String[]{sFileName, sFixUpRuleSetName};
                            throw new OixdInvalidDocumentException("OUI-65013", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65013", (Object[])args2));
                        }
                        oAttrib = oFixUpRuleAttribs.getNamedItem("name");
                        if (oAttrib == null) {
                            Object[] args3 = new String[]{sFileName, sFixUpRuleSetName};
                            throw new OixdInvalidDocumentException("OUI-65016", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65016", (Object[])args3));
                        }
                        String sFixUpRuleName = oAttrib.getNodeValue();
                        oAttrib = oFixUpRuleAttribs.getNamedItem(S_FIXUP_RULE_METHOD_NAME);
                        if (oAttrib == null) {
                            Object[] args4 = new String[]{sFileName, sFixUpRuleName, sFixUpRuleSetName};
                            throw new OixdInvalidDocumentException("OUI-65017", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65017", (Object[])args4));
                        }
                        String sMethod = oAttrib.getNodeValue();
                        oFixUpRule = new OipcfFixUpRule(sFixUpRuleName, sMethod, oFixUpRuleSet);
                        oFixUpRuleSet.addFixUpRule(oFixUpRule);
                    }
                }
                oFixUpRuleMap.addFixUpRuleSet(oFixUpRuleSet);
            }
        }
    }

    OipcfFixUpMap getFixUpMap() {
        return this.m_oFixUpRuleMap;
    }
}

